﻿using System;
using System.Collections.Generic;
using System.Security.Policy;

namespace NVCC.Models
{
    [Serializable]
    public class PatientProfile
    {
        public PatientProfile()
        {
            Appointments = new List<Appointment>();
            Authorizations = new List<Authorization>();
            Consults = new List<UspConsult>();
            MdwsConsults = new List<MdwsConsult>();
            Labs = new List<Lab>();
            Medications = new List<Medication>();
            NonVaMedications = new List<NonVaMedication>();
            Patient = new Patient();
            ProblemDiagnoses = new List<ProblemDiagnosis>();
            RadiologyReports = new List<RadiologyReport>();
            PathologyReports = new List<PathologyReport>();
            VistAImagingStudies = new List<VistAImagingStudy>();
            Allergies = new List<Allergy>();
            NextOfKin = new NextOfKin();
            VistaUser = new ViaUser();
            UserInfo = new User();
            Notes = new List<Note>();
            OpioidNote = new DisclosedProgressNote();
        }
        public IList<Appointment> Appointments { get; set; }
        public IList<Authorization> Authorizations { get; set; }
        public IList<UspConsult> Consults { get; set; }
        public IList<MdwsConsult> MdwsConsults { get; set; }
        public IList<Lab> Labs { get; set; }
        public IList<Medication> Medications { get; set; }
        public IList<NonVaMedication> NonVaMedications { get; set; }


        public bool OpioidExist { get; set; }

        public string OpiodNoteText { get; set; }
        public DisclosedProgressNote OpioidNote {get;set; }

        public Patient Patient { get; set; }
        public IList<ProblemDiagnosis> ProblemDiagnoses { get; set; }
        public IList<RadiologyReport> RadiologyReports { get; set; }
        public IList<PathologyReport> PathologyReports { get; set; }
        public StudiesResult ImagingStudiesResultSet { get; set; }
        public IList<VistAImagingStudy> VistAImagingStudies { get; set; }
        public IList<Allergy> Allergies { get; set; }
        public NextOfKin NextOfKin { get; set; }
        public ViaUser VistaUser { get; set; }
        public User UserInfo {get; set;}
        public IList<Note> Notes { get; set; }
        public Site VistAImagingSite { get; set; }
    }
}
